package com.ibm.ie.reeng.rt.servlet.component;

import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.SetControlRgbcolorByIdI;
import com.ibm.ie.reeng.rt.common.view.SetControlRgbcolorByIdO;

import com.ibm.ie.reeng.rt.servlet.SessionData;
import com.ibm.ie.reeng.rt.servlet.SystemComponent;
import java.awt.Color;
import java.util.HashMap;

public class SetControlRgbcolorById extends SystemComponent
{
    /** Input view. */
    public SetControlRgbcolorByIdI in = new SetControlRgbcolorByIdI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public SetControlRgbcolorByIdO out = new SetControlRgbcolorByIdO();

    protected void clearOutputView() { out.clear(); }


    public void execute(SessionData sessionData)
    {
        in.dump();

        Color color = new Color(in.redColor,
            in.greenColor,
            in.blueColor);


        sessionData.jsp.addComponent(in.hpsItemId,
                         new SetControlColorById.JspData(in.fieldAttr,
                                                         getColor(color)),
                         SetControlColorById.TYPE);

           out.returnCode = ReturnCodes.SUCCESS;
    }


    private String getColor(Color color)
    {
        String colorString = (String)colorTable.get(color);
        //return pink if colour not supported, 
        return (colorString != null) ? colorString : "pink";
    }


    private static HashMap colorTable;
   
    static
    {
        colorTable = new HashMap();

        colorTable.put(Color.white, "white");
        colorTable.put(Color.lightGray, "lightGray");
        colorTable.put(Color.gray, "gray");
        colorTable.put(Color.darkGray, "darkGray");
        colorTable.put(Color.black, "black");
        colorTable.put(Color.red, "red");
        colorTable.put(Color.orange, "orange");
        colorTable.put(Color.yellow, "yellow");
        colorTable.put(Color.green, "green");
        colorTable.put(Color.magenta, "magenta");
        colorTable.put(Color.cyan, "cyan");
        colorTable.put(Color.blue, "blue");    
    } 
}
