package com.ibm.ie.reeng.rt.servlet.component;

import com.ibm.ie.reeng.rt.servlet.JSPComponent;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.set.WindowObjectModes;
import com.ibm.ie.reeng.rt.common.view.SetControlModeByIdI;
import com.ibm.ie.reeng.rt.common.view.SetControlModeByIdO;
import com.ibm.ie.reeng.rt.servlet.SystemComponent;
import com.ibm.ie.reeng.rt.servlet.SessionData;
import com.ibm.ie.reeng.rt.servlet.HtmlToken;

import java.util.ArrayList;

public class SetControlModeById extends SystemComponent
{
    /** Input view. */
    public SetControlModeByIdI in = new SetControlModeByIdI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public SetControlModeByIdO out = new SetControlModeByIdO();

    protected void clearOutputView() { out.clear(); }


    public static final String TYPE = "CONTROL_MODE";

    public static class JspData extends JSPComponent
    {
        private String viewLongName, fieldLongName;
        private String identifier;
        private int mode;


        public JspData(String identifier, int mode)
        {
            this.identifier = identifier;
            this.mode = mode;
        }


        public JspData(String viewLongName, String fieldLongName, int mode)
        {
            this.viewLongName = viewLongName;
            this.fieldLongName = fieldLongName;
            this.mode = mode;
        }


        public ArrayList use(ArrayList htmlList, String guiType)
        {                    
            if(mode == WindowObjectModes.INVISIBLE)
            {
                //clear html line
                htmlList.clear();
            }
            else if(mode == WindowObjectModes.VISIBLE_DISABLED)
            {
                //Place DISABLED before right bracket >

                
                for(int i=0; i<htmlList.size(); i++)
                {
                    HtmlToken token = (HtmlToken)htmlList.get(i);
                    
                    //Check if the readonly flag already set.
                    if(token.contains("READONLY")) 
                    {
                        break;
                    }
                            
                    if(token.contains('>'))
                    {
                        if(guiType.equals(JSPComponent.INPUT))
                            token = new HtmlToken(" READONLY ", "");  
                        else
                            //Insert disabled token before right bracket.                        
                            token = new HtmlToken(" DISABLED ", "");
                                
                        htmlList.add(i, token);
                    
                        break;
                    }
                }                
            }
            else
            {
                //remove readonly flag from html string            
                for(int i=0; i<htmlList.size(); i++)
                {
                    HtmlToken token = (HtmlToken)htmlList.get(i);
                    
                    if(token.contains("READONLY") || token.contains("DISABLED")) 
                    {
                        htmlList.remove(i);
                        break;
                    }
                }                
            }

            return htmlList;            
        }
    }


    public void execute(SessionData sessionData)
    {
        in.dump();

        if (in.hpsListboxCellId != "")
            Log.error(this, "LIST_BOX_CELL_ID is not currently supported");

        sessionData.jsp.addComponent(in.hpsItemId,
                         new JspData(in.hpsItemId,
                                    in.fieldMode),
                         TYPE);
        
        out.returnCode = ReturnCodes.SUCCESS;
    }
}
