package com.ibm.ie.reeng.rt.servlet.component;

import com.ibm.ie.reeng.rt.servlet.JSPComponent;
import com.ibm.ie.reeng.rt.servlet.ColorManager;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.SetControlColorByIdI;
import com.ibm.ie.reeng.rt.common.view.SetControlColorByIdO;
import com.ibm.ie.reeng.rt.servlet.SystemComponent;
import com.ibm.ie.reeng.rt.servlet.SessionData;
import com.ibm.ie.reeng.rt.servlet.HtmlToken;


import java.util.ArrayList;

public class SetControlColorById extends SystemComponent
{
    /** Input view. */
    public SetControlColorByIdI in = new SetControlColorByIdI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public SetControlColorByIdO out = new SetControlColorByIdO();

    protected void clearOutputView() { out.clear(); }


    public final static String TYPE = "CONTROL_COLOUR";
    
    /**
     * Used by SetControlColorById and SetFieldColor.
     */
    public static class JspData extends JSPComponent
    {
        private int action;
        private String color;


        public JspData(int action, String color)
        {
            this.action = action;
            this.color = color;
        }


        public ArrayList use(ArrayList htmlList, String guiType)
        {
            HtmlToken htmlToken;

            for(int i=0; i<htmlList.size(); i++)
            {
                htmlToken = (HtmlToken)htmlList.get(i);
            
                if( htmlToken.getTag().equals("class") )
                {                         
                    htmlToken.setValue(ColorManager.setColor(action, htmlToken.getValue(), color));
                    break; //end for loop
                }
            }
        
            return htmlList;
        }
    }


    protected void execute(SessionData sessionData)
    {
        in.dump();

        sessionData.jsp.addComponent(in.hpsItemId,
                         new JspData(in.fieldAttr,
                                     ColorManager.getColor(in.attrColor)),
                         TYPE);

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
