package com.ibm.ie.reeng.rt.servlet.component;

import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;

import com.ibm.ie.reeng.rt.common.view.ClearWindowChangesI;
import com.ibm.ie.reeng.rt.common.view.ClearWindowChangesO;
import com.ibm.ie.reeng.rt.servlet.SystemComponent;
import com.ibm.ie.reeng.rt.servlet.SessionData;

/**
 * This component resets the status of window objects to the status they had when
 * the window was originally created.  In the current implementation, only
 * the colors of child components are reset.
 * @see com.ibm.ie.reeng.rt.common.TransmuteDialog#resetChildColors
 */
public class ClearWindowChanges extends SystemComponent
{
    /** Input view. */
    public ClearWindowChangesI in = new ClearWindowChangesI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public ClearWindowChangesO out = new ClearWindowChangesO();

    protected void clearOutputView() { out.clear(); }

    
    /**
     * Creates new deferred component and sets returnCode to indicate success.
     */
    protected void execute(SessionData sessionData)
    {
        notImplemented();
        out.returnCode = ReturnCodes.SUCCESS;
    }
}
