package com.ibm.ie.reeng.rt.servlet.component;

import com.ibm.ie.reeng.rt.common.set.ReturnCodes;

import com.ibm.ie.reeng.rt.common.view.ClearSelectedFieldsI;
import com.ibm.ie.reeng.rt.common.view.ClearSelectedFieldsO;
import com.ibm.ie.reeng.rt.servlet.SystemComponent;
import com.ibm.ie.reeng.rt.servlet.SessionData;

/**
 * This component unselects any selected items in any lists
 * appearing on a given window. It does not apply to tables.
 */
public class ClearSelectedFields extends SystemComponent
{
    /** Input view. */
    public ClearSelectedFieldsI in = new ClearSelectedFieldsI();


    public void clearInputView() { in.clear(); }


    /** Output view. */
    public ClearSelectedFieldsO out = new ClearSelectedFieldsO();


    protected void clearOutputView() { out.clear(); }


    protected void execute(SessionData sessionData)
    {   
        //use longname to calculate index
        sessionData.jsp.resetSelectedRow(0);
        out.returnCode = ReturnCodes.SUCCESS;
    }
}
