package com.ibm.ie.reeng.rt.servlet;


public class ServletThreadCtrl
{


    private ServletThreadCtrlState state=ServletThreadCtrlState.RULETHREAD;
    private boolean quitFlag=false;
    

    synchronized private void setState(ServletThreadCtrlState newState)
    {
        state=newState;
        notifyAll();
    }



    
    
    synchronized private void waitForState(ServletThreadCtrlState state)
    {
        while (this.state!=state)
        {
            try
            {
                wait();
            }
            catch (InterruptedException e)
            {
                // Would do some handling here
                // throw (e);
            }
        }
    }


    
    public void ret2Servlet()
    {
        // Let the Servlet take over
        setState(ServletThreadCtrlState.SERVLET);
    }
    
    
    public void waitForEvent()
    {
        // Wait on Servlet to return with results (The next Post)
        // Note: We would put in some logic here to test
        //       for a timeout too.
        waitForState(ServletThreadCtrlState.RULETHREAD);
    }

    
    public void startRule()
    {
        setState(ServletThreadCtrlState.RULETHREAD);
    }


    public void waitForConverse()
    {
        // Wait to regain control, indicating next converse (or quit)
        waitForState(ServletThreadCtrlState.SERVLET);    
    }
}
