package com.ibm.ie.reeng.rt.servlet;

import java.util.Properties;
import java.util.Hashtable;
import java.util.Vector;
import java.io.InputStream;


import com.ibm.ie.reeng.rt.common.LocalRule;
import com.ibm.ie.reeng.rt.common.OverlayMarshall;
import com.ibm.ie.reeng.rt.common.Util;
import com.ibm.ie.reeng.rt.common.Log;


/**
 * The base class for all generated classes corresponding to Hps rules.
 */
public abstract class ServletRule extends LocalRule
{
    protected final static boolean NEST = true;
    protected final static boolean NOWAIT = true;
    protected OverlayMarshall overlay;
    
    protected boolean first_time = true;  
  
    protected void execute(SessionData sessionData){}
    /** Cleans up the rule's window if it has one. */
    protected void finalizeWindow(SessionData sessionData) { }
    /** Initializes the rule's window if it has one. */
    protected void initializeWindow(SessionData sessionData) { }
    // ------------------------------------------------------------------------


    //A reference to the previously stored an instance of the TransmuteJSP class which was
    //previously stored in commonData.
    protected TransmuteJSP prevWindJsp;


    public String toString()
    {
        return Util.toString(this, 2);
    }
//    public void use() { use(false); }
    /**
     * This is the public interface to the rule. Subclasses implement
     * {@link #execute} but users call this method which creates child
     * rules (see {@link #createChildRules}) if necessary, clears the
     * local variables, the output view and the input views of child
     * rules.
     */
    public void use(SessionData sessionData)
    {
/*        if (nest) Log.information(this, "entering nested");
        else Log.information(this, "entering");
*/
        //Initialisation is required to be done only once per rule.
        if (first_time)
        {
            createChildRules();
            first_time = false;
        }

        clearLocalVariables();
        clearOutputView();
        clearChildInputViews();
        initializeWindow(sessionData);
                        
        execute(sessionData);
        finalizeWindow(sessionData);

        Log.information(this, "exiting");
    }

}
