package com.ibm.ie.reeng.rt.servlet;

import java.util.StringTokenizer;
import com.ibm.ie.reeng.rt.common.Log;

public class HtmlToken
{    
    //type, name, readonly etc
    private String tag = "";
    
    //text, identifier, true etc
    private String value = "";

    public HtmlToken(String token)
    {
        //Format of token tag=value    
        //Extract tag + value.
        
        
        int start, last;
        //Href and label names are the exception, where ^ ^ delimit 
        //the text string.

        if(token.indexOf("=") != -1)
        {
            StringTokenizer htmlPair = new StringTokenizer(token,"=");
        
            int count = htmlPair.countTokens();
    
            if(count == 2)
            {
                tag = htmlPair.nextToken();
                value = htmlPair.nextToken();
            }
            else if(count == 1)
            {
                tag = new String(token);
            }
            else
            {
                Log.warning(this, "invalid number of tokens in htmlPair " + count);
            }    
        }
        else
        {
            value = new String(token);
            
            if((start = token.indexOf('^')) != -1)
            {
                last = token.lastIndexOf('^');
                
                value = new String(token.substring(start+1,last));
            
                tag = "valueTag"; //This tag will be removed in the outputted Html
            }
        }
    }

    public HtmlToken(String tag, String value)
    {
        this.tag = tag;
        this.value = value;
    }


    //Modify the html value.
    public void setValue(String value)
    {
        this.value = value;
    }    


    public String getValue(){return value;}
    
    public String getTag(){return tag;}
    

    public String getHtml()
    {
        StringBuffer buf = new StringBuffer();


        if(tag.equals("valueTag")) //temp tag used when setting label and href text values
        {        
            buf.append(value);
        }
        else if(value.equals(""))
        {
            buf.append(tag);
        }
        else if(tag.equals(""))
        {
            buf.append(value);
            buf.append(" ");        
        }
        else
        {
            buf.append(tag);
            buf.append("=");
            buf.append(value);
            buf.append(" ");        
        }

        return buf.toString();
    }

    public boolean contains(char data)
    {
        if(value.indexOf(data) != -1 || tag.indexOf(data) != -1)
            return true;
        else
            return false;
    }    


    public boolean contains(String data)
    {   
        if(value.equals(data) || tag.equals(data))
            return true;
        else
            return false;    
    }

}