package com.ibm.ie.reeng.rt.servlet;

import com.ibm.ie.reeng.rt.common.Config;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.Location;
import com.ibm.ie.reeng.rt.common.Util;


/**
 * The base class for all user and system components.
 */
public abstract class Component
{
//1.2    private static boolean dumpStack = Boolean.getBoolean("trace.stack");
  private static boolean dumpStack = Config.instance().getBoolean("trace.stack");

  
    /**
     * Subclasses must implement this to provide the component logic.
     */

    protected void execute(SessionData sessionData){}


    protected boolean isSystem() { return false; }


    /**
     * Excecutes the component logic. This is the public (user's)
     * interface to the component.
     */
    public void use(SessionData sessionData)
    {
        Log.information(this,
            "entering " + (isSystem() ? "SYSTEM" : "USER") + " component");
        
        if (dumpStack) Location.logStack();

        clearOutputView();

        execute(sessionData);
    }


    public void clearInputView() { }


    protected void clearOutputView() { }

    public String toString()
    {
        return Util.toString(this, 2);
    }    

}

// Note: component should probably derive off Rule - they're almost identical.
