package com.ibm.ie.reeng.rt.servlet;

import com.ibm.ie.reeng.rt.common.set.WindowObjectAttributes;
import com.ibm.ie.reeng.rt.common.set.WindowObjectColors;
import com.ibm.ie.reeng.rt.common.Log;

import java.util.HashMap;
import java.util.StringTokenizer;

/**
 * This class is used by the
 * {@link com.ibm.ie.reeng.rt.servlet.component.SetControlColorById} and 
 * {@link com.ibm.ie.reeng.rt.servlet.component.SetFieldColor} system
 * components.
 * <p>
 * It provides a mapping from  Hps colors into
 * {@link java.awt.Color java.awt.Color}s (see {@link #getColor}).
 * <p>
 * Note that there are limitations in the mapping to Hps color control
 * (see {@link #setColor setColor}).
 */
public class ColorManager
{
    private ColorManager() { }

    /**
     * Notes: Swing has a border concept but there is no generic way to
     * set the color of a border, so HPS BORDER is treated as
     * background. Similarly HPS TEXT is treated foreground.
     *
     * @param action    an element of {@link WindowObjectAttributes}
     */
         
    public static String setColor(int action, String html, String color)
    {
        //note: html string in the format of:
        //foreground_background
        
        StringTokenizer htmlTokens = new StringTokenizer(html,"_");

        String foreground = null;
        String background = null;
        
        int count = htmlTokens.countTokens();
        

        if(count == 2)
        {
            foreground = htmlTokens.nextToken();
            background = htmlTokens.nextToken();
        }
        else
        {
            Log.error("ColorManager", "invalid number of tokens " + count);
        }    

    
        switch (action)
        {
        case WindowObjectAttributes.TEXT:                    
            foreground = "\"" + color;    
            break;

        case WindowObjectAttributes.RESETTEXT:
            Log.warning("ColorManager", "Resetting of foreground colour isn't supported");
            //dialog.resetForeground(component);
            break;

        case WindowObjectAttributes.BORDER:
            Log.warning("ColorManager", "treating BORDER as BACKGROUND");
        case WindowObjectAttributes.BACKGROUND:
            background = color + "\"";
            break;

        case WindowObjectAttributes.RESETBORDER:
            Log.warning("ColorManager", "treating BORDER as BACKGROUND");
        case WindowObjectAttributes.RESETBACKGROUND:
            Log.warning("ColorManager", "Resetting of background colour isn't supported");            
            //dialog.resetBackground(component);
            break;

        default:
            Log.error("ColorManager", "unknown action " + action);
        }
        
                
        return foreground + "_" + background;
    }


    // ------------------------------------------------------------------------


    /**
     * Gets the {@link java.awt.Color java.awt.Color} corresponding to
     * elements of {@link WindowObjectColors}.
     */
    public static String getColor(int i)
    {
        return (String)colorMap.get(new Integer(i));
    }

    private static HashMap colorMap;


    private static void put(int i, String color)
    {
        colorMap.put(new Integer(i), color);
    }


    static
    {
        // Those colors not explicitly enumerated in Color have been
        // created using values derived from X11 rgb.txt

        colorMap = new HashMap();
        put(WindowObjectColors.WHITE,  "white");
        put(WindowObjectColors.YELLOW, "yellow");
        put(WindowObjectColors.BLUE,   "blue");
        put(WindowObjectColors.RED,    "red");
        put(WindowObjectColors.PURPLE, "purple");
        put(WindowObjectColors.ORANGE, "orange");
        put(WindowObjectColors.GREEN,  "green");
        put(WindowObjectColors.MAROON, "maroon");
        put(WindowObjectColors.BLACK,  "black");
        put(WindowObjectColors.AQUA,   "cyan");
    }
}

                
            

