package com.ibm.ie.reeng.rt.common.comms;


import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.Comms;
import com.ibm.ie.reeng.rt.common.Config;
import com.ibm.ie.reeng.rt.common.Util;
import com.ibm.ie.reeng.rt.common.Marshall;


public class EciComms implements Comms
{
    private static String getProperty(String key, String def)
    {
        String v = Config.instance().getString(key);

        return v != null ? v : def;
    }

    private final static String USER_ID = getProperty("user", "CICS");

    private final static String PASSWORD = getProperty("password", "password");

    private final static String SERVER_NAME = getProperty("server", "localhost");

    private final static String ROUTER = getProperty("router", "ROUTER");

    private final static String SERVER_CODEPAGE
        = getProperty("server.codepage", "Cp037");

    private CicsEciAdapter adapter;
    private String sessionId;


    public EciComms()
    {
        try
        {
            adapter = new CicsEciAdapter();
            adapter.connect(SERVER_NAME, USER_ID, PASSWORD);

            int code = java.net.InetAddress.getLocalHost().hashCode();
            String sign;

            sessionId = Integer.toString(code);

            if (sessionId.charAt(0) == '-')
            {
                sessionId = sessionId.substring(1);
                sign = "-";
            }
            else sign = "+";

            sessionId = sign + Util.padLeft(sessionId, 10, Util.ZERO);
        }
        catch (Exception e)
        {
            Log.fatalException(e);
        }
    }


private String ruleName;
    public void send(String ruleName, Marshall marshall)
    {
this.ruleName = ruleName;
        String body = marshall.getWriteBuffer();

        sendAll(ruleName, body, false);
        String result = sendAll(ruleName, body, true);

        marshall.setReadBuffer(result);
    }


    private String sendAll(String ruleName, String body, boolean response)
    {
        final int MAX_LENGTH = 16384;

        int total = body.length();

        String header =
            "0" + // Version number.
            (response ? "O" : "I") +
            sessionId +
            Util.padRight(ruleName, 8, Util.SPACE) +
            Util.padLeft(Integer.toString(total), 10, Util.ZERO);

        StringBuffer resultBuffer = null;
        int offset = 0;
        int sequence = 0;
        char more;

        if (response) resultBuffer = new StringBuffer();

        do
        {
            int length = total - offset;

            if (length <= MAX_LENGTH) more = 'N';
            else
            {
                length = MAX_LENGTH;
                more = 'Y';
            }

            String segmentHeader =
                header +
                Util.padLeft(Integer.toString(length), 10, Util.ZERO) +
                Util.padLeft(Integer.toString(sequence), 3, Util.ZERO) +
                String.valueOf(more);
            String segmentBody = body.substring(offset, (offset + length));

            String result = sendSegment(segmentHeader, segmentBody, response);

            if (response) resultBuffer.append(result);

            sequence++;
            offset += MAX_LENGTH;
        }
        while (more == 'Y');

        if (response) return resultBuffer.toString();
        else return null;
    }


    private String sendSegment(String header, String body, boolean response)
    {
        try
        {
            int headerLength = header.length();
            String commAreaString = header + body;
            byte[] commArea = commAreaString.getBytes(SERVER_CODEPAGE);

            Log.information(this, "segment header - " + header);
            Log.information(this, "body length is " + body.length());

//            commArea = adapter.flow(ROUTER, commArea);
commArea = adapter.flow(ruleName, commArea);

            commAreaString = new String(commArea, SERVER_CODEPAGE);

            header = commAreaString.substring(0, headerLength);

            Log.information(this, "result header is \"" + header + "\"");

            String error = header.substring(1, 4);

            if (!error.equals("000"))
                throw new EciCommsException(error, header.substring(4));

            if (response) return commAreaString.substring(headerLength);
        }
        catch (Exception e)
        {
            Log.fatalException(e);
        }

        return null;
    }


    protected void finalize() throws Throwable
    {
        adapter.disconnect();
    }


    public static class EciCommsException extends RuntimeException
    {
        public EciCommsException(String error, String extra)
        {
            super("error: " + error + ", extra: " + extra);
        }
    }
}
