package com.ibm.ie.reeng.rt.common.comms;

import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.Config;
import com.ibm.ie.reeng.rt.common.Util;

import com.ibm.ctg.client.ECIRequest;

import java.util.Random;
import java.util.Date;

public class CtgServletAppletComms extends CtgComms
{
    private static String userName = getProperty("cics.user");
    private static String password = getProperty("cics.password");

    public CtgServletAppletComms()
    {
        if(!initialised)
        {
            initCtgConfigData(getProperty("jgate.url"),
                              getProperty("cics.server"),
                              getProperty("cics.router"),
                              Config.instance().getInt("cics.commareasize"),
                              getProperty("server.codepage"),
                              Config.instance().getBoolean("ctgcomms.debug"));
        }

        String sessionId = generateSessionId();        
        
        initCtgConnection(sessionId,
                          userName,
                          password);
    }



    private static String getProperty(String name)
    {
        return Config.instance().getString(name);
    }

    private String generateSessionId()
    {
		//JOC int code = java.net.InetAddress.getLocalHost().hashCode();
		int code = new Random(new Date().getTime()).hashCode(); //JOC Ensure unique sessionID    		
		String id = Integer.toString(code);
		
		String sign;    		
		
		if (id.charAt(0) == '-')
		{
			id = id.substring(1);
			sign = "-";
		}
		else 
			sign = "+";
			
		return sign + Util.padLeft(id, 10, Util.ZERO);            
    }



    protected void information(String s)
    {
        Log.information(this,"CtgEjbComms INFO: " + s);
    }

    protected void requestError(ECIRequest req, String extra)
    {
        information("CtgEjbComms ERROR: CICS Transaction Gateway falure: RC = "
            + req.getCicsRcString() + ". " + extra);
    }

    protected void fatalError(String s)
    {
        Log.fatalError(this,s);   
    }

    protected void fatalException(Exception e)
    {
        Log.fatalException(e);   
    }
}




