package com.ibm.ie.reeng.rt.common.comms;


import java.util.Properties;
import java.util.StringTokenizer;

import com.ibm.ie.reeng.rt.common.Log;


public class CicsEciAdapter
{
    private String sServer;
    private String sUserid;
    private String sPassword;


    // Declarations for JNI functions.

    private native String EciRequest(
        String sServerName,    // Name for Server
        String sUserID,        // User ID for Server
        String sPassword,      // Password for Server
        String sProgramName,   // Name of called program
        byte [] byteCommarea); // Sent to Server


    private native String EciSync(
        String sServerName, // Name for Server
        String sUserID,     // User ID for Server
        String sPassword);  // Password for Server


    private final static String LIBRARY = "CicsEciAdapter";


    static
    {
        try
        {
            System.loadLibrary(LIBRARY);
        }
        catch (UnsatisfiedLinkError e)
        {
            Log.fatalError("CicsEciAdapter",
                "could not load library " + LIBRARY);
        }
    }


    public void connect(String server, String userid, String password)
    {
        sServer = server;
        sUserid = userid;
        sPassword = password;

        checkStatus(EciSync(sServer, sUserid, sPassword));

        Log.information(this, "connect status " + status.toString());
    }


    public byte[] flow(String programName, byte[] parameters)
    {
Log.information(this, "parameters.length: " + parameters.length);
        checkStatus(EciRequest(sServer, sUserid, sPassword,
            programName, parameters));

        Log.information(this, "flow status " + status.toString());

        return parameters;
    }


    public void disconnect()
    {
        checkStatus(EciSync(sServer, sUserid, sPassword));

        Log.information(this, "disconnect status " + status.toString());
    }


    // ------------------------------------------------------------------------


    private final static String ECI_NO_ERROR = "ECI_NO_ERROR";
    private final static String CALL_RETURN_CODE = "call.return.code";

    private Properties status = new Properties();


    private void checkStatus(String string)
    {
        StringTokenizer tokenizer = new StringTokenizer(string, "=,");

        while (tokenizer.hasMoreTokens())
        {
            String key = tokenizer.nextToken();
            String value = tokenizer.nextToken();

            status.setProperty(key, value);
        }

        String code = status.getProperty(CALL_RETURN_CODE);

        if (code == null || !code.equals(ECI_NO_ERROR))
            throw new CicsEciAdapterException(status.toString());
    }


    private static class CicsEciAdapterException extends RuntimeException
    {
        public CicsEciAdapterException(String message) { super(message); }
    }
}
