package com.ibm.ie.reeng.rt.common;

import java.util.ArrayList;
import java.sql.SQLException;

/**
 * It's fields are updated by the {@link Connection}, {@link Database},
 * {@link Statement} and {@link ResultSet} classes using the {@link
 * #updateWith} and {@link #reset} methods.
 * <p>
 * Note that sqlcode is actually depreciated from the SQL standard.
 * However we still partially support it. All
 * {@link java.sql.SQLException}s thrown represent "exception
 * conditions" (to use the SQL/92 standard term) and updates to this
 * view are automatically handled by the wrapper classes by using the
 * {@link java.sql.SQLException#getErrorCode} method. However there is no
 * analogue to the SQL/92 term, "completion conditions", in JDBC and we
 * only handle the common "no data" completion condition. 
 */
public class Sqlca extends View
{
    public static final int SQLCODE_SUCCESS = 0;
    public static final int SQLCODE_NO_DATA = 100;

    public Sqlca()
    {
        sqlcaid = "";
        sqlcabc = 0;
        sqlcode = 0;
        sqlerrm = "";
        sqlerrp = "";
        sqlerrd = new Sqlerrd[6];
        for (int i = 0; i < sqlerrd.length; i++)
            sqlerrd[i] = new Sqlerrd();
        sqlwarn = new Sqlwarn();
        sqlext = "";
    }

    /** Reset our condition state. */
    public void reset() { updateWith(SQLConditions.OK); }

    /** Update our condition state using a caught SQLException. */
    public void updateWith(SQLException e)
    {
        if (e == null)
        {
            reset();
        }
        else
        {
            Log.information("", "database exception: ");
            Log.exception(e);
            updateWith(new SQLConditions(e));
        }
    }

    /**
     * Update the Sqlca view to reflect the current conditions.
     */
    private void updateWith(SQLConditions conds)
    {
        clear();
        sqlcode = conds.getSQLCode(0);
        if (sqlcode != 0)
            sqlerrm = conds.getMessage(0);
    }


    public String sqlcaid;

    public int sqlcabc;

    public int sqlcode;

    public String sqlerrm;

    public String sqlerrp;

    public Sqlerrd[] sqlerrd;

    public Sqlwarn sqlwarn;

    public String sqlext;

    public final void clear()
    {
        sqlcaid = "";
        sqlcabc = 0;
        sqlcode = 0;
        sqlerrm = "";
        sqlerrp = "";
        for (int i = 0; i < sqlerrd.length; i++)
            sqlerrd[i].clear();
        sqlwarn .clear();
        sqlext = "";
    }

    public void copyInto(Sqlca v)
    {
        v.sqlcaid = sqlcaid;
        v.sqlcabc = sqlcabc;
        v.sqlcode = sqlcode;
        v.sqlerrm = sqlerrm;
        v.sqlerrp = sqlerrp;
        for (int i = 0; i < sqlerrd.length; i++)
            sqlerrd[i].copyInto(v.sqlerrd[i]);
        sqlwarn.copyInto(v.sqlwarn);
        v.sqlext = sqlext;
    }

    /**
     * This class models the notion of SQL conditions which encode the
     * information available from SQLExceptions.
     */
    private static class SQLConditions
    {
        private static final Condition SUCCESS = new Condition();

        private ArrayList c = new ArrayList();

        public static SQLConditions OK = new SQLConditions();

        private SQLConditions() { c.add(SUCCESS); }

        SQLConditions(SQLException e)
        {
            do
            {
                c.add(new Condition(e));
                e = e.getNextException();
            } while (e != null);
        }

        int size() { return c.size(); }

        public String getSQLState(int i) { return get(i).getSQLState(); }

        public int getSQLCode(int i) { return get(i).getSQLCode(); }

        public String getMessage(int i) { return get(i).getMessage(); }

        private Condition get(int i) { return (Condition)c.get(i); }

        private static class Condition
        {
            private String sqlState  = "00000";
            private int sqlCode = 0;
            private String message = "SQL successful";

            Condition() { }

            Condition(SQLException e)
            {
                sqlState = e.getSQLState();
                sqlCode = e.getErrorCode();
                message = e.getMessage();
            }

            String getSQLState() { return sqlState; }
            int getSQLCode() { return sqlCode; }
            String getMessage() { return message; }
        }
    }

    public void writeMembersTo(Marshall m)
    {
        m.writeChar(sqlcaid, 8);
        m.writeInteger(sqlcabc);
        m.writeInteger(sqlcode);
        m.writeVarchar(sqlerrm, 70);
        m.writeChar(sqlerrp, 8);
        for (int i = 0; i < sqlerrd.length; i++)
            sqlerrd[i].writeTo(m);
        sqlwarn.writeTo(m);
        m.writeChar(sqlext, 8);
    }

    public void readMembersFrom(Marshall m)
    {
        sqlcaid = m.readChar(8);
        sqlcabc = m.readInteger();
        sqlcode = m.readInteger();
        sqlerrm = m.readVarchar(70);
        sqlerrp = m.readChar(8);
        for (int i = 0; i < sqlerrd.length; i++)
            sqlerrd[i].readFrom(m);
        sqlwarn.readFrom(m);
        sqlext = m.readChar(8);
    }
}
