package com.ibm.ie.reeng.rt.common;


/**
 * This implementation of Marshall is used to support the Hps SIZEOF
 * support function. It is consistant with the results of
 * OverlayMarshall. I.e. <BR>
 * <code>new OverlayMarshall.writeXXX(x).getWriteLength()
 *      == new SizeofMarshall.writeXXX(x).getLength()</code><BR>
 * By induction this property also applies to Views.
 */
public class SizeofMarshall extends Marshall
{
    public boolean readBoolean()
    {
        throw new RuntimeException("boolean marshalling not yet supported");
    }
    
    public Marshall writeBoolean(boolean field)
    {
        throw new RuntimeException("boolean marshalling not yet supported");
    }
    
    /**
     * This Marshall doesn't actually store the values which are
     * marshalled.
     */
    public byte[] getWriteByteBuffer()
    {
        throw new RuntimeException("operation illegal on SizeofMarshall");
    }

    private int length = 0;

    public int getLength() { return length; }

    public Marshall writeChar(String field, int length)
    {
        this.length += length;

        return this;
    }

    public Marshall writeVarchar(String field, int length)
    {
        this.length += 2;
        this.length += length;

        return this;
    }

    public Marshall writeSmallint(int field)
    {
        this.length += 2;
        return this;
    }

    public Marshall writeInteger(int field)
    {
        this.length += 4;
        return this;
    }


    public Marshall writePic(double field, boolean signed,
        int length, int fraction)
    {
        this.length += length;

        return this;
    }


    /**
     * Note: the field length of DEC data items does not include the sign.
     */
    public Marshall writeDec(double field, int length, int fraction)
    {
        this.length += length + 1;

        return this;
    }


    /**
     * Dates are treated as Integers as in OverlayMarshall.
     */
    public Marshall writeDate(java.sql.Date field)
    {
        this.length += 4;

        return this;
    }


    /**
     * Times are treated as Integers as in OverlayMarshall.
     */
    public Marshall writeTime(java.sql.Time field)
    {
        this.length += 4;

        return this;
    }


    public Marshall writeTimestamp(java.sql.Timestamp field)
    {
        this.length += 12;

        return this;
    }

    // ------------------------------------------------------------------------


    public String readChar(int length)
    {
        throw new RuntimeException("operation illegal on SizeofMarshall");
    }

    public String readVarchar(int length)
    {
        throw new RuntimeException("operation illegal on SizeofMarshall");
    }

    public int readSmallint()
    {
        throw new RuntimeException("operation illegal on SizeofMarshall");
    }

    public int readInteger()
    {
        throw new RuntimeException("operation illegal on SizeofMarshall");
    }

    public double readPic(boolean signed, int length, int fraction)
    {
        throw new RuntimeException("operation illegal on SizeofMarshall");
    }

    public double readDec(int length, int fraction)
    {
        throw new RuntimeException("operation illegal on SizeofMarshall");
    }

    public java.sql.Date readDate()
    {
        throw new RuntimeException("operation illegal on SizeofMarshall");
    }

    public java.sql.Time readTime()
    {
        throw new RuntimeException("operation illegal on SizeofMarshall");
    }

    public java.sql.Timestamp readTimestamp()
    {
        throw new RuntimeException("operation illegal on SizeofMarshall");
    }
}
