package com.ibm.ie.reeng.rt.common;


/**
 * This provides a simple implementation of <code>Trace</code>. Output
 * is written to stdout.
 */
public class SimpleTrace implements Trace
{
    public void output(String text) { System.out.println(text); }

    public void information(Object source, String text)
    {
        output("INFORMATION: " + text);
    }

    public void warning(Object source, String text)
    {
        output("WARNING: " + text);
    }

    public void error(Object source, String text)
    {
        output("ERROR: " + text);
    }

    public void fatalError(Object source, String text)
    {
        output("FATAL: " + text);
        System.exit(-1);
    }

    public void exception(Exception e)
    {
        output("EXCEPTION:");
        e.printStackTrace();
    }

    public void fatalException(Exception e)
    {
        output("FATAL EXCEPTION:");
        e.printStackTrace();
        System.exit(-1);
    }
}
