package com.ibm.ie.reeng.rt.common;


/**
 * This is an "sink" implementation of the Trace interface. By
 * specifying this class as the {@link Log} target, no logging
 * information is generated by the runtime.
 */
public class NullTrace implements Trace
{
    public void output(String text) { }

    public void information(Object source, String text) { }

    public void warning(Object source, String text) { }

    public void error(Object source, String text) { }

    public void fatalError(Object source, String text) { System.exit(-1); }

    public void exception(Exception e) { }

    public void fatalException(Exception e) { System.exit(-1); }
}
