package com.ibm.ie.reeng.rt.common;

import java.util.ArrayList;

/**
 * This extends {@link Set} functionality with the ability to supply a
 * list of "display strings". These are used for combo-boxes and lists.
 */
public class LookupSet extends Set
{
    private ArrayList displayList;

    /**
     * Subclasses override this method to provide a list of display
     * strings.
     */
    protected DisplayString[] getDisplayStrings()
    {
        return new DisplayString[0];
    }


    /**
     * This constructor clones the name list and replaces any names
     * corresponding to values for which a display string has been
     * defined.
     */
    protected LookupSet()
    {
        displayList = (ArrayList)nameList.clone();

        DisplayString[] displayStrings = getDisplayStrings();

        for (int i = 0; i < displayStrings.length; i++)
        {
            String name = getName(displayStrings[i].getValue());
            int j = nameList.indexOf(name);

            displayList.set(j, displayStrings[i].getString());
        }
    }

    public Object getDisplay(int i) { return displayList.get(i); }

    protected int getPosition(Object display)
    {
        return displayList.indexOf(display);
    }
}
