package com.ibm.ie.reeng.rt.common;

import java.util.StringTokenizer;

/**
 * The base class for {@link ServerRule} and {@link ClientRule}.
 * Subclasses contain executable business logic.
 */
public abstract class LocalRule implements java.io.Serializable
{
    protected OverlayMarshall overlay;

    /**
     * Any variables declared locally to a rule are cleared each time
     * the rule is used. So descendants should implement this function
     * to perform that task.
     */
    protected void clearLocalVariables() { }

    /**
     * 
     */
    protected void clearOutputView() { }

    public String getHpsName() { return ""; }

    /**
     * Users of a rule invoke this method when they themselves are used.
     */
    public void clearInputView() { }

    public View getInputView() { return null; }
    public void setInputView(View in) {}

    public View getOutputView() { return null; }
    public void setOutputView(View out) {}

    /**
     * When a rule is used the input views of any rules it uses are
     * cleared.  Subclasses implement this function to perform that
     * task.
     */
    protected void clearChildInputViews() { }

    /**
     * For performance/latency reasons the entire heirarchy is created
     * by need. Child rules are only created when a rule is first used.
     */
    protected void createChildRules() { }


    // ------------------------------------------------------------------------


    /**
     * HPS allows unsigned PIC data values with no fractional component
     * to be used as if they were strings. This function is used to
     * convert a double appropriately when simulating this behavior.
     */
    protected static String pic(double real, int length)
    {
        String string = Util.toDoubleString(real);

        int pos = string.indexOf('.');

        string = string.substring(0, pos);

        if (string.charAt(0) == '-')
            string = string.substring(1, string.length());

        return Util.padLeft(string, length, Util.ZERO);
    }

    /** Pads or truncates a <code>String</code>.  */
    protected static String adjustLength(String string, int length)
    {
        if (string.length() > length) string = string.substring(0, length);

        return Util.unpadRight(string, Util.SPACE);
    }

    /**
     * Convert character data represented by a java.lang.String into
     * corresponding SQL of a character literal.
     */
    public static String sqlEncodeString(String s)
    {
        // Handle the common case.
        if (s.indexOf('\'') == -1)
            return "'" + s + "'";

        StringTokenizer toks = new StringTokenizer(s, "'", true);
        StringBuffer buf = new StringBuffer();
        while (toks.hasMoreTokens())
        {
            String tok = toks.nextToken();
            if (tok.equals("'")) buf.append("''");
            else buf.append(tok);
        }
        return "'" + buf + "'";
    }

    /**
     * Return either a string representation of the passed variable
     * or "null" if the boolean nullIndicator is true
     */
    protected String sqlNullableValue(String s, int nullIndicator)
    {
        if (nullIndicator!=0)
            return NULL_STRING;
        else
            return s;
    }

    protected String sqlNullableValue(int i, int nullIndicator)
    {
        if (nullIndicator!=0)
            return NULL_STRING;
        else
            return new Integer(i).toString();
    }

    protected String sqlNullableValue(float f, int nullIndicator)
    {
        if (nullIndicator!=0)
            return NULL_STRING;
        else
            return new Float(f).toString();
    }

    protected String sqlNullableValue(double d, int nullIndicator)
    {
        if (nullIndicator!=0)
            return NULL_STRING;
        else
            return new Double(d).toString();
    }

    private static final String NULL_STRING="null";

    /**
     * When we extract CHAR(n) fields from the Database, we need to
     * rtrim them.
     */
    protected static final String getChar(java.sql.ResultSet curs, int pos)
    throws java.sql.SQLException
    {
        String s = curs.getString(pos);
        if (s == null) return "";
        else return Function.rtrim(s);
    }

    public String toString()
    {
        return Util.toString(this, 2);
    }
}
