package com.ibm.ie.reeng.rt.common;


/**
 * This class contains constants to represent the various types of Hps
 * GUI events. It is included in the runtime (rather than using
 * a generated class) because of the heavy dependence of many of the
 * other runtime classes.
 */
public class HpsEventType extends ValueSet
{
    public static Set instance() 
    {
        if (instance == null) instance = new HpsEventType();
        return instance;
    }

    private static Set instance;

    private HpsEventType() { }

    public final static int LANDP_SYS_EVENT = 6;
    public final static int INTERFACE_EVENT = 1;
    public final static int SYSTEM_EVENT = 0;
    public final static int USER_EVENT = 2;
    public final static int LANDP_EVENT = 3;
    public final static int LANDP_REQUEST = 4;

    public static String toString(int eventType)
    {
        switch (eventType)
        {
        case LANDP_SYS_EVENT: return "LANDP_SYS_EVENT";
        case INTERFACE_EVENT: return "INTERFACE_EVENT";
        case SYSTEM_EVENT: return "SYSTEM_EVENT";
        case USER_EVENT: return "USER_EVENT";
        case LANDP_EVENT: return "LANDP_EVENT";
        case LANDP_REQUEST: return "LANDP_REQUEST";
        default:
            Log.fatalError("HpsEventType", "bad event type");
            return null;
        }
    }
}
