package com.ibm.ie.reeng.rt.common;

import com.ibm.ie.reeng.rt.common.LocalRule;


/**
 * The base class for all user and system components.
 */
public abstract class Component implements java.io.Serializable
{
    private static boolean dumpStack
        = Config.instance().getBoolean("trace.stack");
  
    private static boolean nonFatal
        = Config.instance().getBoolean("trace.unimplemented.syscomps.nonfatal");

    protected boolean isSystem() { return false; }

    protected void prepareToExecute()
    {
        Log.information(this,
            "entering " + (isSystem() ? "SYSTEM" : "USER") + " component");
        
        if (dumpStack) Location.logStack();

        clearOutputView();
    }

    public void clearInputView() { }

    protected void clearOutputView() { }

    private LocalRule callingRule;

    protected LocalRule getCallingRule()
    {
        return callingRule;
    }

    public void setCallingRule(LocalRule rule)
    {
        callingRule=rule;
    }

    /**
     * This is useful for preliminary testing.
     */
    protected void notImplemented()
    {
        String message = "system component not implemented";
        if (nonFatal) Log.error(this.getClass().getName(), message);
        else Log.fatalError(this.getClass().getName(), message);
    }

    public String toString()
    {
        return Util.toString(this, 2);
    }
}
