package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.SetWindowTitleI;
import com.ibm.ie.reeng.rt.common.view.SetWindowTitleO;


public class SetWindowTitle extends SystemComponent
{
    /** Input view. */
    public SetWindowTitleI in = new SetWindowTitleI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public SetWindowTitleO out = new SetWindowTitleO();

    protected void clearOutputView() { out.clear(); }


    private static class Deferred extends DeferredComponent
    {
        private String title;


        public Deferred(String title)
        {
            this.title = title;
        }


        public void use(TransmuteDialog dialog)
        {
            dialog.setTitle(title);
        }
    }


    public void execute()
    {
        in.dump();

        String title = in.captionText;
        int length = in.titleLength;

        if (length > 0)
        {
            length = Math.min(length, title.length());
            title = title.substring(0, length);
        }

        TransmuteDialog.addDeferred(new Deferred(title));

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
