package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.SetWindowPositionI;
import com.ibm.ie.reeng.rt.common.view.SetWindowPositionO;


/**
 * This component sets the position of a non-nested window.
 */
public class SetWindowPosition extends SystemComponent
{
	/** Input view. */
	public SetWindowPositionI in = new SetWindowPositionI();

	public void clearInputView() { in.clear(); }


	/** Output view. */
	public SetWindowPositionO setWindowPositionO = new SetWindowPositionO();

	protected void clearOutputView() { setWindowPositionO.clear(); }

    private static class Deferred extends DeferredComponent
    {
        private int iLeftPosition;
        private int iTopPosition;


        public Deferred(int iLeftPosition, int iTopPosition)
        {        
        	// TODO get decision on resetting position to 0,0 if -x or -y	
            this.iLeftPosition = (iLeftPosition < 0?0:iLeftPosition);
            this.iTopPosition = (iTopPosition < 0?0:iTopPosition);
        }

        public void use(TransmuteDialog dialog)
        {    
        	dialog.setLocation(iLeftPosition,iTopPosition);
        }
    }

	protected void execute()
	{
		// log the input view attributes
		in.dump();
		
        TransmuteDialog.addDeferred(new Deferred(
            in.leftPosition,            
            in.topPosition));		
		
		TransmuteDialog dialog = TransmuteDialog.getCurrentDialog();
	
		setWindowPositionO.returnCode = ReturnCodes.SUCCESS;
	}
}
