package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.client.TransmuteList;
import com.ibm.ie.reeng.rt.client.TransmuteTable;
import com.ibm.ie.reeng.rt.client.TransmuteTableModel;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.SetVirtualListboxSizeI;
import com.ibm.ie.reeng.rt.common.view.SetVirtualListboxSizeO;


public class SetVirtualListboxSize extends SystemComponent
{
    /** Input view. */
    public SetVirtualListboxSizeI in = new SetVirtualListboxSizeI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public SetVirtualListboxSizeO out = new SetVirtualListboxSizeO();

    protected void clearOutputView() { out.clear(); }


    private static class Deferred extends DeferredComponent
    {
        private String viewLongName;
        private int numberOfRecords;
        private int elevatorPosition;


        public Deferred(String viewLongName, int numberOfRecords,
            int elevatorPosition)
        {
            this.viewLongName = viewLongName;
            this.numberOfRecords = numberOfRecords;

            // Subtract one as HPS indexes from 1.
            if (elevatorPosition > 0) elevatorPosition--;

            this.elevatorPosition = elevatorPosition;
        }


        public void use(TransmuteDialog dialog)
        {
            TransmuteTable table =
                (TransmuteTable)dialog.findChildByDatalink(viewLongName);

            if (table == null) return; // Error has been reported by find.

            table.resetState(); // Clear out any previous internal state.

            TransmuteTableModel model = table.getTransmuteTableModel();
//model.setBackBuffer(0);
            model.setVirtualRowCount(numberOfRecords);

            table.setElevatorPosition(elevatorPosition);

            // Note: while HPS_TBL_INIT_SIZE is very similar to
            // SET_VIRTUAL_LISTBOX_SIZE only HPS_TBL_INIT_SIZE
            // causes an INIT event to be dispatched.
        }
    }


    public void execute()
    {
        in.dump();

        TransmuteDialog.addDeferred(new Deferred(
            in.viewLongName,
            in.numberOfRecords,
            in.elevatorPosition));

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
