package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.TransmuteButton;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.set.PushModeStates;
import com.ibm.ie.reeng.rt.common.view.SetPushModeI;
import com.ibm.ie.reeng.rt.common.view.SetPushModeO;

/**
 * This system component is not currently implemented. Its use causes an
 * error to be logged.
 */
public class SetPushMode extends SystemComponent
{
    public SetPushMode() { }

    /**
     * Input view.
     */
    public SetPushModeI in = new SetPushModeI();

    public void clearInputView() { in.clear(); }

    /**
     * Output view.
     */
    public SetPushModeO out = new SetPushModeO();

    protected void clearOutputView() { out.clear(); }
    

    private static class Deferred extends DeferredComponent
    {
        private String text;
        private int mode;
        
        public Deferred(String text, int mode)
        {
            this.text = text;
            this.mode = mode;
        }
        
        
        public void use(TransmuteDialog dialog)
        {
            java.awt.Component[] components
                = dialog.findChildrenByClass(TransmuteButton.class);
            for(int i = 0; i < components.length; i++)
            {
                //casting to TransmuteButtonpushMode
                TransmuteButton thisButton = (TransmuteButton)components[i];
                String label = thisButton.getText();
                if(label.equals(text))
                {
                    if(mode == PushModeStates.INVISIBLE_DISABLED)
                    {
                        thisButton.setEnabled(false);
                        thisButton.setVisible(false);
                    }   
                    else if(mode == PushModeStates.VISIBLE_DISABLED)
                    {
                        thisButton.setEnabled(false);
                        thisButton.setVisible(true);                        
                    }   
                    else if(mode == PushModeStates.VISIBLE_ENABLED)
                    {
                        thisButton.setEnabled(true);
                        thisButton.setVisible(true);                        
                    }   
                }   
            }   
        }   
        
    }   
  
    
    protected void execute()
    {
        in.dump();
            
        TransmuteDialog.addDeferred(
            new Deferred(in.pushText,
            in.pushMode));
            
        out.returnCode = ReturnCodes.SUCCESS;
    }
}
