package com.ibm.ie.reeng.rt.client.component;

import java.awt.Point;

import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.TransmuteTable;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.SetPopupPositionI;
import com.ibm.ie.reeng.rt.common.view.SetPopupPositionO;

import com.ibm.ie.reeng.rt.common.set.WindowPositions;


/**
 * This system component is not currently implemented. Its use causes an
 * error to be logged.
 */
public class SetPopupPosition extends SystemComponent
{
	/** Input view. */
	public SetPopupPositionI in = new SetPopupPositionI();

	public void clearInputView() { in.clear(); }


	/** Output view. */
	public SetPopupPositionO setPopupPositionO = new SetPopupPositionO();

	protected void clearOutputView() { setPopupPositionO.clear(); }

    private static class Deferred extends DeferredComponent
    {
        private int iPopupType;
        private int iLeftPosition;
        private int iTopPosition;


        public Deferred(int iPopupType, int iLeftPosition, int iTopPosition)
        {
            this.iPopupType = iPopupType;
            this.iLeftPosition = iLeftPosition;
            this.iTopPosition = iTopPosition;
        }

		/* poptype is the type of positioning..
		 * 1 = Absolute coordinates (0, 0 is the top left of the screen)
		 * 2 = Relative to the entire window
		 * 3 = Relative to the client area (the panel area inside the window)
		 */
		// am assuming that the dialog that calls this is 
		// the popup window that needs to be repositioned
        public void use(TransmuteDialog dialog)
        {    
        	// use the WINDOW_POSITION sets
        	switch (iPopupType)
        	{
        		// set the absolute position
        		case WindowPositions.ABSOLUTE_COORDINAT:
        		{        	
        			dialog.setLocation(iLeftPosition,iTopPosition);
        			break;
        		}	
        		// set relative to entire window
        		case WindowPositions.LOGICAL_TO_WINDOW:
        		{
        			// get the parent dialog position
		        	final Point parentPosition = getParentPosition(dialog);        			
		        	
					// calculate the new absolute position        			
        			int iNewLeftPosition = parentPosition.x +iLeftPosition;
        			int iNewTopPosition = parentPosition.y +iTopPosition;
        			
        			// If the new position is a minus, reset to zero 
        			iNewLeftPosition = (iNewLeftPosition<0?0:iNewLeftPosition);        		     		
        			iNewTopPosition = (iNewTopPosition<0?0:iNewTopPosition);
        			
        			// set the dialog position
        			dialog.setLocation(iNewLeftPosition,iNewTopPosition);
        			break;	
        		}						
        		//set relative to client area	         				
        		case WindowPositions.LOGICAL_TO_CLIENT:
        		{
        			// get the parent dialog position
		        	final Point parentPosition = getParentPosition(dialog);
		        	
		        	//get the clientArea position
		        	Point clientAreaPosition = parentPosition;        	
		    		final java.awt.Container clientArea = TransmuteDialog.getParentDialog(dialog).getContentPane();
		    		
		    		// if the clientArea is null, then use parent position
		    		if(clientArea==null)
		    		{
		    			clientAreaPosition = clientArea.getLocation();
		    		}        			
		        	
					// calculate the new absolute position        			
        			int iNewLeftPosition = clientAreaPosition.x +iLeftPosition;
        			int iNewTopPosition = clientAreaPosition.y +iTopPosition;        			
		        			
					// If the new position is a minus, reset to zero
        			iNewLeftPosition = (iNewLeftPosition<0?0:iNewLeftPosition);        		     		
        			iNewTopPosition = (iNewTopPosition<0?0:iNewTopPosition);
        			
        			// set the dialog position
        			dialog.setLocation(iNewLeftPosition,iNewTopPosition);        			
        			break;							         				       		       		        		
        		}
        	}    	        	
        }
    }
    
    /* 
     * Get a point with the position of the parent
     */
    private static final Point getParentPosition(TransmuteDialog dialog)
	{
		TransmuteDialog logicalParent=dialog.getLogicalParent();
//		final TransmuteDialog parentDialog = dialog.getParentDialog(dialog);
		Point parentPosition = new  Point(0,0);
		if(logicalParent != null )
		{
			parentPosition = logicalParent.getLocation();
		}
		return parentPosition;
	}
    


    protected void execute()
    {
        in.dump();

        TransmuteDialog.addDeferred(new Deferred(
            in.poptype,
            in.leftPosition,            
            in.topPosition));

        setPopupPositionO.returnCode = ReturnCodes.SUCCESS;
    }
}
