package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.TransmuteMenuItem;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.set.MenuItemAttributes;
import com.ibm.ie.reeng.rt.common.set.MenuItemState;
import com.ibm.ie.reeng.rt.common.view.SetMenuModeByIdI;
import com.ibm.ie.reeng.rt.common.view.SetMenuModeByIdO;


public class SetMenuModeById extends SystemComponent
{
    /** Input view. */
    public SetMenuModeByIdI in = new SetMenuModeByIdI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public SetMenuModeByIdO out = new SetMenuModeByIdO();

    protected void clearOutputView() { out.clear(); }


    private static class Deferred extends DeferredComponent
    {
        private String identifier;
        private int attribute, state;


        public Deferred(String identifier, int attribute, int state)
        {
            this.identifier = identifier;
            this.attribute = attribute;
            this.state = state;
        }


        public void use(TransmuteDialog dialog)
        {
            TransmuteMenuItem item =
                dialog.findMenuItemByIdentifier(identifier);

            if (item == null) return; // Error has been reported by find.

            if (attribute == MenuItemAttributes.ENABLE)
                item.setEnabled(state == MenuItemState.HPS_ON);
            else // attribute == MenuItemAttributes.CHECK
            {
                if (state == MenuItemState.HPS_ON)
                    item.showCheckedCheckBox();
                else item.hideCheckBox();
            }
        }
    }


    public void execute()
    {
        in.dump();

        TransmuteDialog.addDeferred(
            new Deferred(in.hpsItemId,
                in.hpsMitemAttribute,
                in.hpsMitemState));

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
