package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.TransmuteLabel;
import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.SetItemTextI;
import com.ibm.ie.reeng.rt.common.view.SetItemTextO;

import javax.swing.*;


public class SetItemText extends SystemComponent
{
    /** Input view. */
    public SetItemTextI in = new SetItemTextI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public SetItemTextO out = new SetItemTextO();

    protected void clearOutputView() { out.clear(); }


    private static class Deferred extends DeferredComponent
    {
        private String identifier, text;
        private char mnemonic;


        public Deferred(String identifier, String text, char mnemonic)
        {
            this.identifier = identifier;
            this.text = text;
            this.mnemonic = mnemonic;
        }


        public void use(TransmuteDialog dialog)
        {
            java.awt.Component child =
                dialog.findChildByIdentifier(identifier);

            if (child == null) return; // Error has been reported by find.

            if (child instanceof AbstractButton)
            {
                AbstractButton button = (AbstractButton)child;

                button.setText(text);
                button.setMnemonic(mnemonic);
            }
            else if (child instanceof JLabel)
            {
                JLabel label = (JLabel)child;

                label.setText(text);
            }
            else if (child instanceof TransmuteLabel)
            {
                TransmuteLabel transmuteLabel = (TransmuteLabel)child;

                transmuteLabel.setText(text);
            }
        }
    }


    public void execute()
    {
        in.dump();

        char[] original = in.hpsItemText.toCharArray();
        StringBuffer buffer = new StringBuffer();
        boolean found = false;
        char mnemonic = 0;

        for (int i = 0; i < original.length; i++)
        {
            char c = original[i];

            if (!found && c == '&') found = true;
            else
            {
                if (found)
                {
                    if (c != '&') mnemonic = c;
                    found = false;
                }
                buffer.append(c);
            }
        }

        TransmuteDialog.addDeferred(
            new Deferred(in.hpsItemId, buffer.toString(), mnemonic));

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
