package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.TransmuteTable;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.SetFirstVisibleOccurrenceI;
import com.ibm.ie.reeng.rt.common.view.SetFirstVisibleOccurrenceO;

import javax.swing.JViewport;
import java.awt.Point;

public class SetFirstVisibleOccurrence extends SystemComponent
{
    /** Input view. */
    public SetFirstVisibleOccurrenceI in = new SetFirstVisibleOccurrenceI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public SetFirstVisibleOccurrenceO out = new SetFirstVisibleOccurrenceO();

    protected void clearOutputView() { out.clear(); }


    private static class Deferred extends DeferredComponent
    {
        private String viewLongName;
        private int fieldOccur;


        public Deferred(String viewLongName, int fieldOccur)
        {
            this.viewLongName = viewLongName;
            this.fieldOccur = fieldOccur;
        }


        public void use(TransmuteDialog dialog)
        {
            java.awt.Component child =
                dialog.findChildByDatalink(viewLongName);

            if (child == null) return; // Error has been reported by find.

            TransmuteTable table = (TransmuteTable)child;

            // Note HPS indexes from 1. The fieldOccur value is virtual.
            // However table.getElevatorPosition() is normalized (i.e. is
            // indexed from 0).
            // HPS indexes from 1.
            table.setFirstVisibleRow(fieldOccur - 1);
        }
    }


    protected void execute()
    {
        in.dump();

        TransmuteDialog.addDeferred(new Deferred(
            in.viewLongName,
            in.fieldOccur));

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
