package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.TransmuteTextField;
import com.ibm.ie.reeng.rt.client.TransmuteComboBox;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.set.WindowObjectModes;
import com.ibm.ie.reeng.rt.common.view.SetFieldModeI;
import com.ibm.ie.reeng.rt.common.view.SetFieldModeO;


public class SetFieldMode extends SystemComponent
{
    /** Output view. */
    public SetFieldModeO out = new SetFieldModeO();

    protected void clearOutputView() { out.clear(); }


    /** Input view. */
    public SetFieldModeI in = new SetFieldModeI();

    public void clearInputView() { in.clear(); }

    public static class EditDeferred extends DeferredComponent
    {
        private int mode;

        public EditDeferred(int mode) { this.mode = mode; }

        public void use(TransmuteDialog dialog)
        {
            setModeMultiple(
                dialog.findChildrenByClass(TransmuteTextField.class, false));

            setModeMultiple(
                dialog.findChildrenByClass(TransmuteComboBox.class, false));
        }

        private void setModeMultiple(java.awt.Component[] components)
        {
            boolean visible = mode != WindowObjectModes.INVISIBLE;
            boolean enabled = mode != WindowObjectModes.VISIBLE_DISABLED;

            for (int i = 0; i < components.length; i++)
            {
                components[i].setVisible(visible);
                components[i].setEnabled(enabled);
            }
        }
    }


    /**
     * Note that there are special cases if fieldLongName is "*EDIT" or
     * "*TEXT". 
     */
    protected void execute()
    {
        in.dump();

        if (in.fieldLongName.equals("*EDIT"))
        {
            TransmuteDialog.addDeferred(
                new EditDeferred(in.fieldMode));
        }
        else if (in.fieldLongName.equals("*TEXT"))
        {
            Log.error(this, "\"*TEXT\" field specifier not supported");
        }
        else
        {
            TransmuteDialog.addDeferred(
                new SetControlModeById.Deferred(
                    in.viewLongName, in.fieldLongName,
                    in.fieldMode));
        }

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
