package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.TransmuteTable;
import com.ibm.ie.reeng.rt.client.TransmuteList;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.SetCursorFieldI;
import com.ibm.ie.reeng.rt.common.view.SetCursorFieldO;


public class SetCursorField extends SystemComponent
{
    /** Input view. */
    public SetCursorFieldI in = new SetCursorFieldI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public SetCursorFieldO out = new SetCursorFieldO();

    protected void clearOutputView() { out.clear(); }


    private static class Deferred extends DeferredComponent
    {
        private String viewLongName, fieldLongName;
        private int listboxOccur;


        public Deferred(String viewLongName, String fieldLongName,
            int listboxOccur)
        {
            this.viewLongName = viewLongName;
            this.fieldLongName = fieldLongName;

            if (listboxOccur != 0) listboxOccur--; // HPS indexes from 1.

            this.listboxOccur = listboxOccur;
        }


        public void use(TransmuteDialog dialog)
        {
            java.awt.Component component = dialog.findChildByDatalink(
                viewLongName, fieldLongName);

            if (component == null) return; // Error has been reported by find.

            if (component instanceof TransmuteList)
            {
                TransmuteList list = (TransmuteList)component;

                list.requestFocus(listboxOccur);
            }
            else if (component instanceof TransmuteTable)
            {
                TransmuteTable table = (TransmuteTable)component;

                table.requestFocus(listboxOccur, 0);
            }
            else component.requestFocus();
        }
    }


    public void execute()
    {
        in.dump();

        TransmuteDialog.addDeferred(new Deferred(
            in.viewLongName, in.fieldLongName,
            in.listboxOccur));

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
