package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.set.WindowObjectModes;
import com.ibm.ie.reeng.rt.common.view.SetControlModeByIdI;
import com.ibm.ie.reeng.rt.common.view.SetControlModeByIdO;


public class SetControlModeById extends SystemComponent
{
    /** Input view. */
    public SetControlModeByIdI in = new SetControlModeByIdI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public SetControlModeByIdO out = new SetControlModeByIdO();

    protected void clearOutputView() { out.clear(); }


    public static class Deferred extends DeferredComponent
    {
        private String viewLongName, fieldLongName;
        private String identifier;
        private int mode;


        public Deferred(String identifier, int mode)
        {
            this.identifier = identifier;
            this.mode = mode;
        }


        public Deferred(String viewLongName, String fieldLongName, int mode)
        {
            this.viewLongName = viewLongName;
            this.fieldLongName = fieldLongName;
            this.mode = mode;
        }


        public void use(TransmuteDialog dialog)
        {
            java.awt.Component child = dialog.findChild(identifier,
                viewLongName, fieldLongName);

            if (child == null) return; // Error has been reported by find.

            child.setVisible(mode != WindowObjectModes.INVISIBLE);
            child.setEnabled(
                mode != WindowObjectModes.VISIBLE_DISABLED);
        }
    }


    public void execute()
    {
        in.dump();

        if (in.hpsListboxCellId != "")
            Log.error(this, "LIST_BOX_CELL_ID is not currently supported");

        TransmuteDialog.addDeferred(
            new Deferred(in.hpsItemId,
                in.fieldMode));

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
