package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.client.ColorManager;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.SetControlColorByIdI;
import com.ibm.ie.reeng.rt.common.view.SetControlColorByIdO;

import java.awt.Color;


public class SetControlColorById extends SystemComponent
{
    /** Input view. */
    public SetControlColorByIdI in = new SetControlColorByIdI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public SetControlColorByIdO out = new SetControlColorByIdO();

    protected void clearOutputView() { out.clear(); }


    /**
     * Used by SetControlColorById and SetFieldColor.
     */
    public static class Deferred extends DeferredComponent
    {
        private String viewLongName, fieldLongName;
        private String identifier;
        private int action;
        private Color color;


        public Deferred(String viewLongName, String fieldLongName,
            int action, Color color)
        {
            this.viewLongName = viewLongName;
            this.fieldLongName = fieldLongName;
            this.action = action;
            this.color = color;
        }


        public Deferred(String identifier, int action, Color color)
        {
            this.identifier = identifier;
            this.action = action;
            this.color = color;
        }


        public void use(TransmuteDialog dialog)
        {
            java.awt.Component child =
                dialog.findChild(identifier, viewLongName, fieldLongName);

            if (child == null) return; // Error has been reported by find.

            ColorManager.setColor(dialog, child, action, color);
        }
    }


    protected void execute()
    {
        in.dump();

        TransmuteDialog.addDeferred(
            new Deferred(in.hpsItemId,
            in.fieldAttr,
            ColorManager.getColor(in.attrColor)));

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
