package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.TransmuteTable;
import com.ibm.ie.reeng.rt.client.TransmuteTableModel;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.HpsTblGetDataStateI;
import com.ibm.ie.reeng.rt.common.view.HpsTblGetDataStateO;


public class HpsTblGetDataState extends SystemComponent
{
    /** Output view. */
    public HpsTblGetDataStateO out = new HpsTblGetDataStateO();

    protected void clearOutputView() { out.clear(); }


    /** Input view. */
    public HpsTblGetDataStateI in = new HpsTblGetDataStateI();

    public void clearInputView() { in.clear(); }


    protected void execute()
    {
        TransmuteTable table = (TransmuteTable)TransmuteDialog.
            getCurrentDialog().
            findChildByIdentifier(in.hpsItemId);

        if (table == null)
        {
            out.returnCode = ReturnCodes.FAILURE;
            return; // Error has been reported by find.
        }

        TransmuteTableModel model = table.getTransmuteTableModel();

        // Add 1 to all values as HPS indexes from 1 rather than 0.

        // the new elevator position will be:
        out.elevatorPosition =
                        table.getFirstVisibleRowVirtualOccurrence() + 1;

        out.hpsVirtualStartPos = model.getVirtualStartPos() + 1;
        out.hpsVirtualEndPos = model.getVirtualEndPos() + 1;
        out.hpsViewStartPos = model.getViewStartPos() + 1;
        out.hpsViewEndPos = model.getViewEndPos() + 1;

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
