package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.TransmuteTable;
import com.ibm.ie.reeng.rt.client.TransmuteTableModel;
import com.ibm.ie.reeng.rt.client.TransmuteList;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.HpsSetSelectedFieldI;
import com.ibm.ie.reeng.rt.common.view.HpsSetSelectedFieldO;


/**
 * Note: the current implementation does not support multiple calls
 * proceeding a converse - each call selecting more rows or cells.  Each
 * call currently overrides the effects of a previous call.
 */
public class HpsSetSelectedField extends SystemComponent
{
    /** Input view. */
    public HpsSetSelectedFieldI in = new HpsSetSelectedFieldI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public HpsSetSelectedFieldO out = new HpsSetSelectedFieldO();

    protected void clearOutputView() { out.clear(); }


    private static class Deferred extends DeferredComponent
    {
        private String identifier, listboxCellId;
        int start, end;


        public Deferred(String identifier, String listboxCellId,
            int start, int end)
        {
            this.identifier = identifier;
            this.listboxCellId = listboxCellId;

            if (end == 0) end = start;

            // Note: HPS indexes from 1 while Java indexes from 0.
            this.start = start - 1;
            this.end = end - 1;
        }


        public void use(TransmuteDialog dialog)
        {
            java.awt.Component component =
                dialog.findChildByIdentifier(identifier);

            if (component == null) return; // Error has been reported by find.

            if (component instanceof TransmuteTable)
            {
                TransmuteTable table = (TransmuteTable)component;

                table.setRowSelectionInterval(start, end);

                if (!listboxCellId.equals(""))
                {
                    TransmuteTableModel model = table.getTransmuteTableModel();

                    int column = model.findColumnByIdentifier(listboxCellId);

                    if (column == -1) return; // Error has been reported...

                    table.setColumnSelectionInterval(column, column);
                }
            }
            else if (component instanceof TransmuteList)
            {
                TransmuteList list = (TransmuteList)component;

                list.setSelectionInterval(start, end);
            }
            else
            {
                Log.error(this, "unexpected child class " +
                    component.getClass().getName());

                return;
            }
        }
    }


    public void execute()
    {
        in.dump();

        TransmuteDialog.addDeferred(new Deferred(
            in.hpsItemId,
            in.hpsListboxCellId,
            in.hpsFieldOccurStart,
            in.hpsFieldOccurEnd));

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
