package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.HpsSetHelpTopicI;
import com.ibm.ie.reeng.rt.common.view.HpsSetHelpTopicO;


public class HpsSetHelpTopic extends SystemComponent
{
    /** Output view. */
    public HpsSetHelpTopicO out = new HpsSetHelpTopicO();

    protected void clearOutputView() { out.clear(); }


    /** Input view. */
    public HpsSetHelpTopicI in = new HpsSetHelpTopicI();

    public void clearInputView() { in.clear(); }

    private static class Deferred extends DeferredComponent
    {
        private String hpsId;
        private String windowLongName;

        public Deferred(String windowLongName, String hpsId)
        {
            this.hpsId = hpsId;
            this.windowLongName = windowLongName;
        }


        public void use(TransmuteDialog dialog)
        {
            if (dialog.getLongName().equals(windowLongName)) 
                dialog.setHelpTopic(hpsId);
        }
    }



    protected void execute()
    {
        in.dump();

        TransmuteDialog.addDeferred(new Deferred(
            in.windowLongName,
            in.helpKeyword));

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
