package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.HpsSetActivateI;
import com.ibm.ie.reeng.rt.common.view.HpsSetActivateO;


/**
 * HPS v5.4 - SYSCOMP.pdf - p.42
 * "When called by a rule, this component makes the next window conversed active.
 *  That is, it brings that window to the top of all other windows and gives it the
 *  focus. When used with an HPS_ACTIVE_STATE of Inactive, this component
 *  causes the next window conversed to come to the top in an inactive state. If the
 *  window conversed appears on top of the active window, it drops back behind the
 *  active window." - 
 */
public class HpsSetActivate extends SystemComponent
{
	/** Input view. */
	public HpsSetActivateI in = new HpsSetActivateI();

	public void clearInputView() { in.clear(); }


	/** Output view. */
	public HpsSetActivateO out = new HpsSetActivateO();

	protected void clearOutputView() { out.clear(); }
	
	
    private static class Deferred extends DeferredComponent
    {
        private int iHpsActiveState;

        public Deferred(int iHpsActiveState)
        {
            this.iHpsActiveState = iHpsActiveState;
        }

        public void use(TransmuteDialog dialog)
        {    
        	// active state
			if(iHpsActiveState == 1)
			{
				dialog.show();			
			}	  
			// inactive state
			else if(iHpsActiveState == 0)
			{
				dialog.show();
				dialog.toBack();
			}
        }        	
    }
    
    protected void execute()
    {
		// log the input view attributes
		in.dump();
    	
        TransmuteDialog.addDeferred(new Deferred(in.hpsActiveState));    	
            		
		out.returnCode = ReturnCodes.SUCCESS;
	}
}
