package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.set.HpsWindowStates;
import com.ibm.ie.reeng.rt.common.view.HpsGetMinmaxO;

import java.awt.Frame;


public class HpsGetMinmax extends SystemComponent
{
    /** Output view. */
    public HpsGetMinmaxO out = new HpsGetMinmaxO();

    protected void clearOutputView() { out.clear(); }


    protected void execute()
    {
        TransmuteDialog current = TransmuteDialog.getCurrentDialog();

        if (current == null)
        {
            Log.error(this, "there is no current window");
            out.returnCode = ReturnCodes.FAILURE;

            return;
        }

        int state = current.getState();

        out.hpsWindowState = (state == Frame.ICONIFIED) ?
            HpsWindowStates.MINIMIZED : HpsWindowStates.NORMAL;

        // Note: Java does not support maximizing windows.

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
