package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.GetTextMessageI;
import com.ibm.ie.reeng.rt.common.view.GetTextMessageO;

import java.util.ResourceBundle;
import java.util.MissingResourceException;
import java.util.StringTokenizer;


public class GetTextMessage extends SystemComponent
{
    private static final String MESSAGE_BUNDLE_NAME
        = "textmessages";

    private static ResourceBundle bundle;

    static
    {
        try
        {
            bundle = ResourceBundle.getBundle(MESSAGE_BUNDLE_NAME);
        }
        catch (MissingResourceException e) { e.printStackTrace(); }
    }

    /** Input view. */
    public GetTextMessageI in = new GetTextMessageI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public GetTextMessageO out = new GetTextMessageO();

    protected void clearOutputView() { out.clear(); }


    protected void execute()
    {
        if (bundle == null)
        {
            Log.error(this, MESSAGE_BUNDLE_NAME + ".properties not found.");
            out.returnCode = ReturnCodes.FAILURE;
            return;
        }

        String key = in.messageSetName + ".longname";

        try
        {
            String setLongName = bundle.getString(key);

            key = setLongName + "." + in.textCode;

            String text = bundle.getString(key);

            StringTokenizer toks = new StringTokenizer(text, "\n", false);
            if (toks.hasMoreTokens())
                out.txtArg1 = toks.nextToken();
            if (toks.hasMoreTokens())
                out.txtArg2 = toks.nextToken();
            if (toks.hasMoreTokens())
                out.txtArg3 = toks.nextToken();
            if (toks.hasMoreTokens())
                out.txtArg4 = toks.nextToken();
            out.returnCode = ReturnCodes.SUCCESS;
        }
        catch (MissingResourceException e)
        {
            Log.error(this, key + " is not defined in " +
                MESSAGE_BUNDLE_NAME + ".properties");
            out.returnCode = ReturnCodes.FAILURE;
        }
    }
}
