package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.TransmuteColumn;
import com.ibm.ie.reeng.rt.client.TransmuteTable;
import com.ibm.ie.reeng.rt.client.DataHandler;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.GetSelectedFieldI;
import com.ibm.ie.reeng.rt.common.view.GetSelectedFieldO;


public class GetSelectedField extends SystemComponent
{
    /** Input view. */
    public GetSelectedFieldI in = new GetSelectedFieldI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public GetSelectedFieldO out = new GetSelectedFieldO();

    protected void clearOutputView() { out.clear(); }


    public void execute()
    {
        in.dump();

        // Guilty until proven...
        out.returnCode = ReturnCodes.FAILURE;

        if (in.fieldOccur > 0)
        {
            Log.error(this, "occurrance selection is not currently supported");
            return;
        }

        boolean getFirst = in.fieldOccur == -1;

        String view = in.viewLongName;
        String field = in.fieldLongName;

        TransmuteDialog dialog = TransmuteDialog.getCurrentDialog();

        java.awt.Component component = dialog.findChildByDatalink(view, field, false);

        if (component == null)
        {
            // it may be a column of a table?
            if (view.equals("") && field.equals("")) return;

            java.awt.Component[] tables
                = dialog.findChildrenByClass(TransmuteTable.class);

            TransmuteColumn column = null;
            TransmuteTable table = null;
            for (int i = 0; i < tables.length; i++)
            {
                table = (TransmuteTable)tables[i];
                column = table.getColumnByDatalink(view, field);
                if (column != null) break;
            }

            if (column == null)
            {
                Log.error(this, "could not find child " + view + "." + field);
                return;
            }

            out.viewLongName = column.getPrimaryView();
            out.fieldLongName = column.getPrimaryField();

            component = table;
        }
        else
        {
            DataHandler.Interface dataHandler = (DataHandler.Interface)component;

            out.viewLongName =
                dataHandler.getDataHandler().getPrimaryView();
            out.fieldLongName =
                dataHandler.getDataHandler().getPrimaryField();
        }

        if (component instanceof TransmuteTable)
        {
            TransmuteTable table = (TransmuteTable)component;

            if (getFirst) table.storeSelectedRows();

            if (table.hasNextSelectedRow())
            {
                // HPS indexes from 1.
                out.fieldOccur = table.nextSelectedRow() + 1;

                out.returnCode = ReturnCodes.SUCCESS;
            }
        }
        else
        {
            Log.error(this, component.getClass().getName() +
                " is not currently supported");
        }
    }
}
