package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.TransmuteTable;
import com.ibm.ie.reeng.rt.client.TransmuteTableModel;
import com.ibm.ie.reeng.rt.common.view.GetListboxWindowSizesI;
import com.ibm.ie.reeng.rt.common.view.GetListboxWindowSizesO;

import java.awt.Rectangle;


/**
 * Note: this component is only for multi-column list boxes.
 */
public class GetListboxWindowSizes extends SystemComponent
{
    /** Input view. */
    public GetListboxWindowSizesI in = new GetListboxWindowSizesI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public GetListboxWindowSizesO out = new GetListboxWindowSizesO();

    protected void clearOutputView() { out.clear(); }


    protected void execute()
    {
        in.dump();

        TransmuteTable table = (TransmuteTable)TransmuteDialog.
            getCurrentDialog().findChildByDatalink(
                in.viewLongName);

        if (table == null) return; // Error has been reported by find.

        TransmuteTableModel model = table.getTransmuteTableModel();

        int visibleRows = table.getVisibleRowCount();
        int realRows = model.getRealRowCount();

        out.visibleOccurs = Math.min(visibleRows, realRows);

        out.scrollableOccurs = realRows;
    }
}
