package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.Config;
import com.ibm.ie.reeng.rt.common.view.GetFullUserIdentityO;


/**
 * This component returns information about the current user and
 * workstation. Java guarantees that the &quot;user.name&quot; system
 * property will be set. The workstation id returned is simply the value
 * of the &quot;workstation.id&quot; property which should be set
 * appropriately in the runtime.properties file.
 * <p>
 * Note this component has no imput view.
 */
public class GetFullUserIdentity extends SystemComponent
{
    /** Output view. */
    public GetFullUserIdentityO out = new GetFullUserIdentityO();

    protected void clearOutputView() { out.clear(); }


    protected void execute()
    {
        out.workstationId30 = Config.instance().getString("workstation.id");

        if (out.workstationId30 == null)
        {
            Log.warning(this, "\"workstation.id\" property is not set");
            out.workstationId30 = "";
        }

        out.userId30 = Config.instance().getString("user.name");

        if (out.userId30 == null)
        {
            Log.warning(this, "\"user.name\" property is not set");
            out.userId30 = "";
        }
    }
}
