package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.ClearWindowChangesI;
import com.ibm.ie.reeng.rt.common.view.ClearWindowChangesO;

/**
 * This component resets the status of window objects to the status they had when
 * the window was originally created.  In the current implementation, only
 * the colors of child components are reset.
 * @see transmute.runtime.TransmuteDialog#resetChildColors
 */
public class ClearWindowChanges extends SystemComponent
{
    /** Input view. */
    public ClearWindowChangesI in = new ClearWindowChangesI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public ClearWindowChangesO out = new ClearWindowChangesO();

    protected void clearOutputView() { out.clear(); }

    private static class Deferred extends DeferredComponent
    {
        private String windowLongName;
    
        public Deferred(String windowLongName)
        {
            this.windowLongName = windowLongName;
        }
        
        public void use(TransmuteDialog dialog)
        {    
            if (!dialog.getLongName().equals(windowLongName))
                dialog = TransmuteDialog.findWindow(windowLongName);
        
            if (dialog == null) return; // Error has been reported by find.
          
            dialog.resetChildColors();
        }
    }
    
    /**
     * Creates new deferred component and sets returnCode to indicate success.
     */
    protected void execute()
    {
        TransmuteDialog.addDeferred(new Deferred(in.windowLongName));
        out.returnCode = ReturnCodes.SUCCESS;
    }
}
