package com.ibm.ie.reeng.rt.client.component;

import com.ibm.ie.reeng.rt.client.SystemComponent;
import com.ibm.ie.reeng.rt.client.TransmuteDialog;
import com.ibm.ie.reeng.rt.client.TransmuteList;
import com.ibm.ie.reeng.rt.client.DeferredComponent;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;

import com.ibm.ie.reeng.rt.common.view.ClearSelectedFieldsI;
import com.ibm.ie.reeng.rt.common.view.ClearSelectedFieldsO;

/**
 * This component unselects any selected items in any lists
 * appearing on a given window. It does not apply to tables.
 */
public class ClearSelectedFields extends SystemComponent
{
    /** Input view. */
    public ClearSelectedFieldsI in = new ClearSelectedFieldsI();


    public void clearInputView() { in.clear(); }


    /** Output view. */
    public ClearSelectedFieldsO out = new ClearSelectedFieldsO();


    protected void clearOutputView() { out.clear(); }


    private static class Deferred extends DeferredComponent
    {
        private String windowLongName;


        public Deferred(String windowLongName)
        {
            this.windowLongName = windowLongName;
        }


        public void use(TransmuteDialog dialog)
        {
            // Unusually (uniquely?) for a deferred component this
            // component does not necessarily act on the current window.
            
            if (!dialog.getLongName().equals(windowLongName))
                dialog = TransmuteDialog.findWindow(windowLongName);

            if (dialog == null) return; // Error has been reported by find.

            java.awt.Component[] children =
                dialog.findChildrenByClass(TransmuteList.class);

            if (children == null) return; // Error has been reported by find.

            for (int i = 0; i < children.length; i++)
            {
                TransmuteList child = (TransmuteList)children[i];

                child.clearSelection();
            }
        }
    }


    protected void execute()
    {
        in.dump();

        TransmuteDialog.addDeferred(new Deferred(in.windowLongName));

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
