package com.ibm.ie.reeng.rt.client.applet;

import com.ibm.ie.reeng.rt.common.Marshall;
import com.ibm.ie.reeng.rt.common.Comms;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.Config;

import java.net.URL;
import java.net.URLConnection;

import java.io.OutputStream;
import java.io.InputStream;    

/*
 * A URLConnection is made to the server passing the rule name as parameters 
 * and the marshall as a stream.
 */

public class HttpComms implements Comms 
{
    private String ruleName;

    public void send(String ruleName, Marshall marshall)
    {
        this.ruleName = ruleName;

        String body = marshall.getWriteBuffer();

        String result = sendAll(ruleName, body);

        marshall.setReadBuffer(result);
    }


    private String sendAll(String ruleName, String body)
    {
        byte buffer[] = new byte[500];
        String inString = new String();
        String urlString
            = Config.instance().getString("HttpCommsServlet.URL");
        
        if (urlString == null)
        {
            Log.warning(this, "HttpCommsServlet.URL not set");
            urlString = "http://localhost:8080/HttpCommsServlet/HttpCommsServlet";
        }

        urlString += "?" + ruleName;
//      urlString += "?" + URLEncoder.encode(ruleName);

        try {
            
            
            URL url = new URL(urlString);

/*
            // Open connection (URLConnection) and cast it to HttpURLConnection     
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
*/


            Log.information(this, "Attempting to connect to URL " + urlString );
            // Open connection - cannot use HttpURLConnection as MS Explore VM causes a java.lang.ClassCastException (com/ms/net/wininet/http/HttpURLConnection)
            URLConnection connection = url.openConnection();

            connection.setDoOutput(true);
            OutputStream out = connection.getOutputStream();
            //String postString = new String("rulename=" + URLEncoder.encode(ruleName) + "&");
            //Log.information(this, "Sending to HttpCommsServlet :" + postString);
            //out.write(postString.getBytes());
            //String bodyString = new String("body=" + URLEncoder.encode(body) + "&");
            //Log.information(this, "Sending to HttpCommsServlet :" + bodyString);
            //out.write(bodyString.getBytes());
            Log.information(this, "Data sent to HttpCommsServlet :" + body);
            out.write(body.getBytes());
            out.close();


            // Open input stream with connection
            InputStream in = connection.getInputStream();
            // Variable to store bytes read
            int count = 0;
            //int avail=in.available();
            // Read bytes into buffer
            while ((count = in.read(buffer)) > 0) {
                // Report how many bytes read
                //Log.information(this, "Read " + count + " bytes.");
                String strBuffer = new String(buffer,0, count);
                inString += strBuffer;
                //Log.information(this, "buffer = " + strBuffer );
            }
            Log.information(this, "Data received from HttpCommsServlet :" + inString);
            in.close();
        }
        catch (Exception e){
            e.printStackTrace();
        }
        return inString;
    }
  
 }
