package com.ibm.ie.reeng.rt.client.applet;

import com.ibm.ie.reeng.rt.client.Rule;

import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.Util;
import com.ibm.ie.reeng.rt.common.Config;
import com.ibm.ie.reeng.rt.common.Trace;
import com.ibm.ie.reeng.rt.common.NullTrace;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.GridLayout;
import java.awt.Cursor;

import javax.swing.UIManager;
import javax.swing.JButton;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Applet extends JApplet
{
    public Applet()
    { 
        Config.setSource(new ConfigSource(this));

        try
        {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) { die("error: " + e); }

        // Hack to avoid ugly message about system event access check.
        getRootPane().putClientProperty(
            "defeatSystemEventQueueCheck", Boolean.TRUE);
    }

    private JButton go;
    private String className;
    private Rule rule;

    public void init()
    {
        if (Config.instance().getBoolean("debug"))
            Log.setTrace(new AppletTrace());
        else Log.setTrace(new NullTrace());

        // The rule class:
        className = Config.instance().getString("rule");

        // The go button:
        String buttonText = Config.instance().getString("buttontext");
        if (buttonText == null) buttonText = "Go!";

        go = new JButton(buttonText);
        go.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                startRule();
            }
        });

        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1,1));
        panel.add(go);
        setContentPane(panel);
    }

    private void showMessage(String message)
    {
        JOptionPane.showMessageDialog(this, message, "Error",
            JOptionPane.ERROR_MESSAGE, null);
    }

    private void die(String message)
    {
        showMessage(message);
        throw new RuntimeException(message);
    }

    private void startRule()
    {
        go.setEnabled(false);
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        try
        {
            rule = (Rule)Class.forName(className).newInstance();
            new Thread()
            {
                public void run()
                {
                    try { rule.use(); }
                    catch (Exception e) { Log.exception(e); showMessage(e.getMessage()); }
                    SwingUtilities.invokeLater(new Runnable()
                    {
                        public void run()
                        {
                            go.setEnabled(true);
                            setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
                        }
                    });
                }
            }.start();
        }
        catch (ClassNotFoundException e)
        {
            die("cannot load rule class " + className);
        }
        catch (Exception e)
        {
            die("error loading " + className + ": " + e);
        }
    }

    /**
     * This provides a simple implementation of <code>Trace</code>.
     * Output is written to stderr.
     */
    private static class AppletTrace implements Trace
    {
        public void output(String text) { System.out.println(text); }

        public void information(Object source, String text)
        {
            output("INFORMATION: (" + name(source) + ") " + text);
        }

        public void warning(Object source, String text)
        {
            output("WARNING: (" + name(source) + ") " + text);
        }

        public void error(Object source, String text)
        {
            output("ERROR: (" + name(source) + ") " + text);
        }

        public void fatalError(Object source, String text)
        {
            output("FATAL: (" + name(source) + ") " + text);
            throw new RuntimeException(text);
        }

        public void exception(Exception e)
        {
            output("EXCEPTION:");
            e.printStackTrace();
        }

        public void fatalException(Exception e)
        {
            output("FATAL EXCEPTION:");
            e.printStackTrace();
            throw new RuntimeException(e.getClass() + ": " + e.getMessage());
        }

        private static String name(Object source)
        {
            if (source instanceof String) return source.toString();
            return source.getClass().getName();
        }
    }
}

