package com.ibm.ie.reeng.rt.client;

import javax.swing.UIManager;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Keymap;

import java.awt.Color;
import java.awt.Toolkit;

import java.awt.event.KeyEvent;


/**
 * Provides Hps edit field functionality.
 */
public class TransmuteTextField extends JTextFieldBugFix
    implements Identifier, DataHandler.Interface, TextDataHandler.Interface,
               java.io.Serializable
{
    private TextDataHandler handler = new TextDataHandler(this);


    public DataHandler getDataHandler() { return handler; }


    public TransmuteTextField() { setDisabledTextColor(getForeground()); }


    public void setClientData(ClientData clientData)
    {
        handler.setClientData(clientData);
        setMaxLength(clientData.getMaxLength());
    }


    // ------------------------------------------------------------------------


    public boolean isFocusTraversable()
    {
        return (isEditable() ? super.isFocusTraversable() : false);
    }


    public Color getBackground()
    {
        Color background = super.getBackground();

        if (background == null) return null;

        // I'm not sure about this change.
        if (!isEnabled()) return UIManager.getColor("Panel.background");

        // If it's been set to something special...
        if (!background.equals(UIManager.getColor("TextField.background")))
            return background;

        return isEditable() ? background : UIManager.getColor("Panel.background");
    }

    public void setMandatory(boolean mandatory)
    {
        getDataHandler().setMandatory(mandatory);
    }

    public boolean getMandatory()
    {
        return getDataHandler().getMandatory();
    }

    public void setImmediateReturn(boolean immediateReturn)
    {
        getDataHandler().setImmediateReturn(immediateReturn);
    }

    public boolean getImmediateReturn()
    {
        return getDataHandler().getImmediateReturn();
    }


    // ------------------------------------------------------------------------


    private int maxLength = Integer.MAX_VALUE;


    private void setMaxLength(int maxLength) { this.maxLength = maxLength; }


    protected Document createDefaultModel()
    {
        return new MaxLengthDocument();
    }


    private class MaxLengthDocument extends PlainDocument
    {
        public void insertString(int offset, String string, AttributeSet set) 
            throws BadLocationException
        {
            int max = maxLength - getLength();

            if (max == 0) Toolkit.getDefaultToolkit().beep();
            else
            {
                if (string.length() > max)
                {
                    Toolkit.getDefaultToolkit().beep();
                    string = string.substring(0, max);
                }

                super.insertString(offset, string, set);
            }
        }
    }


    // ------------------------------------------------------------------------


    private String identifier;

    public String getIdentifier() { return identifier; }

    public void setIdentifier(String identifier)
    {
        this.identifier = identifier;
    }


    // ------------------------------------------------------------------------


    /** Turn off AWT compatibility mode (see javadoc for JTextField). */
    static
    {
        JTextField field = new JTextField();
        KeyStroke enter = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0);
        Keymap map = field.getKeymap();
        map.removeKeyStrokeBinding(enter);
    }
}
