package com.ibm.ie.reeng.rt.client;

import com.ibm.ie.reeng.rt.common.Util;

//import javax.swing.*;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.Icon;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.JToggleButton;
import javax.swing.UIManager;



import javax.swing.plaf.basic.BasicCheckBoxMenuItemUI;


/**
 * Implements a menu item.
 * <p>
 * Note that in Java a normal menu item and one with a check box (ticked
 * or unticked) are quite distinct things - one cannot latter become the
 * other. However in HPS a menu item that starts out plain can be
 * changed into one with a check box and vice versa by calling a system
 * component. To simulate this we make all menu items check box menu
 * items but add in some extra code to the normal JCheckBoxMenuItem to
 * allow its check box to be made visible or invisible depending on
 * whether we want a check box menu item or to simulate a normal plain
 * menu item.
 */
public class TransmuteMenuItem extends JCheckBoxMenuItem
    implements Identifier, Checking.Interface, java.io.Serializable
{
    public void addDefaultActionListener(String name)
    {
        Action action = Util.getAction(name);

        addActionListener(action);

        KeyStroke[] keyStrokes = Util.getKeyStrokesForAction(action);

        if (keyStrokes != null) setAccelerator(keyStrokes[0]);
    }


    // ------------------------------------------------------------------------


    private String identifier;

    public String getIdentifier() { return identifier; }

    public void setIdentifier(String identifier)
    {
        this.identifier = identifier;
    }


    // ------------------------------------------------------------------------


    private Checking checking = new Checking();


    public Checking checking() { return checking; }


    // ------------------------------------------------------------------------


    // See note above about switching between a normal plain menu item
    // and a check box menu item.

    // Note: this code works irespective of the current look and feel,
    // some of the complexity covers L&Fs where there is a visual
    // distinction between an unchecked check box menu item and a plain
    // menu item (in MS Windows there's no visual distinction).


    private TransmuteCheckBoxMenuItemUI menuItemUI;
    private TransmuteMenuItemModel model;

    public TransmuteMenuItem()
    {
        this("");
    }

    public TransmuteMenuItem(String text)
    {
        super(text);

        menuItemUI = new TransmuteCheckBoxMenuItemUI();

        setUI(menuItemUI);

        model = new TransmuteMenuItemModel();

        setModel(model);

        hideCheckBox();
    }


    private static class TransmuteMenuItemModel
        extends JToggleButton.ToggleButtonModel
            implements java.io.Serializable
    {
        public void setSelected(boolean b) { /* NOP */ }


        public void showCheckMark() { stateMask |= SELECTED; }


        public void hideCheckMark() { stateMask &= ~SELECTED; }
    }



    public void showCheckedCheckBox()
    {
        menuItemUI.showCheckBox();
        model.showCheckMark();
    }


    public void hideCheckBox()
    {
        menuItemUI.hideCheckBox();
        model.hideCheckMark();
    }


    public boolean isCheckBoxVisible()
    {
        return menuItemUI.isCheckBoxVisible();
    }


    private static class TransmuteCheckBoxMenuItemUI
        extends BasicCheckBoxMenuItemUI
            implements java.io.Serializable
    {
        private Icon invisibleIcon =
            UIManager.getIcon("MenuItem.checkIcon");
        private Icon visibleIcon =
            UIManager.getIcon("CheckBoxMenuItem.checkIcon");


        protected void installDefaults()
        {
            Icon current = checkIcon;

            // Note: installDefaults() overwrites checkIcon.
            super.installDefaults();

            checkIcon = current;
        }


        public void showCheckBox()
        {
            checkIcon = visibleIcon;
        }


        public void hideCheckBox()
        {
            checkIcon = invisibleIcon;
        }


        public boolean isCheckBoxVisible()
        {
            return checkIcon == visibleIcon;
        }
    }
}
