package com.ibm.ie.reeng.rt.client;

//import javax.swing.*;
import javax.swing.JButton;

import java.awt.Insets;
import java.awt.Cursor;

/**
 * A simple extension of {@link javax.swing.JButton} to support some
 * functionality required by Hps system components.
 * <p>
 * Note the constructor calls {@link javax.swing.JButton#setDefaultCapable}
 * to disable Swing's currently broken default button handling. This
 * stops Swing clobbering our Actions for the the enter key which have
 * been set up in {@link TransmuteDialog#setEnterAction}.
 *
 * This is similar to TransmuteButton - except that it is transparent and has a 
 * "hand cursor" when the mouse is over it.
 */
public class TransmuteHotspot extends JButton
    implements Identifier, Checking.Interface, java.io.Serializable
{
    /**
     */
    public TransmuteHotspot()
    {
        setDefaultCapable(false);
        setContentAreaFilled(false);    // make transparent
        setBorderPainted(false);
        setMargin(new Insets(0,0,0,0)); // margin of zero size
//      setFocusPainted(false);         // when pressing the hotspot 'focus' is not shown
        setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
    }


    public Insets getInsets() { return new Insets(0, 0, 0, 0); }


    // ------------------------------------------------------------------------


    private String identifier;

    public String getIdentifier() { return identifier; }

    public void setIdentifier(String identifier)
    {
        this.identifier = identifier;
    }


    // ------------------------------------------------------------------------


    private Checking checking = new Checking();


    public Checking checking() { return checking; }
}
