package com.ibm.ie.reeng.rt.client;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;


/**
 * This class is used by {@link TransmuteComboBox},
 * {@link TransmuteTextArea} and {@link TransmuteTextField}
 * instances to get and retrieve "linked" data. For a general discussion
 * of this topic see {@link ClientData} and {@link DataHandler}.
 */
public class TextDataHandler extends DataHandler implements FocusListener, java.io.Serializable
{
    private String initialData = "";
    private TextDataHandler.Interface textComponent;

private TextDataHandler()
{
}

    public interface Interface
    {
        public String getText();

        public void setText(String text);
    }


    public TextDataHandler(TextDataHandler.Interface textComponent)
    {
        super((JComponent)textComponent);

        this.textComponent = textComponent;

        component.addFocusListener(this);
    }


    public void focusGained(FocusEvent e) { }


    public void focusLost(FocusEvent event)
    {
        if (event.isTemporary()) return;

        String newData = textComponent.getText();

        boolean changed = !initialData.equals(newData);

        if (changed) stateChanged();
    }


    protected void stateChangedHandler(int storeResult)
    {
        if (storeResult == INVALID) component.setBackground(Color.red);
        else getDialog().resetBackground(component);
    }


    /**
     * Note: if a text field has no client data its text may have been
     * set by a system component.
     */
    public void displayData()
    {
        if (clientData == null) initialData = textComponent.getText();
        else
        {
            initialData = clientData.getString();

            if (!initialData.equals(textComponent.getText()))
            {
                // Calling setText on a JTextField which has some of its
                // current text selected causes strange rendering
                // problems.
                textComponent.setText(initialData);
            }
        }
    }


    public int storeData()
    {
        String text = textComponent.getText();

        if (text.equals(""))
        {
            if (clientData != null) clientData.clear();

            return getMandatory() ? EMPTY : VALID;
        }

        if (clientData == null) return VALID;

        return clientData.setString(text) ? VALID : INVALID;
    }
}
